#ifndef _ASM_UNIT_INTCTL_REGS_H
#define _ASM_UNIT_INTCTL_REGS_H

#ifndef _ASM_ARCH_INTCTL_REGS_H
# error "please don't include this file directly"
#endif

#define DETCONFR2	0x61830008

#define XIRQ_TRIGGER_LOWLEVEL	0
#define XIRQ_TRIGGER_HILEVEL	1
#define XIRQ_TRIGGER_NEGEDGE	2
#define XIRQ_TRIGGER_POSEDGE	3

#define GET_XIRQ_TRIGGER(X)			\
({						\
	unsigned int x;				\
	x = (inl(DETCONFR2) >> ((X)+16)) & 0x1;	\
	if (X) {				\
		x ^= XIRQ_TRIGGER_HILEVEL;	\
	}					\
	else {					\
		x ^= XIRQ_TRIGGER_POSEDGE;	\
	}					\
	x;					\
})

#define SET_XIRQ_TRIGGER(X,Y)			\
({						\
	unsigned int x;				\
	x = inl(DETCONFR2);			\
	if ((Y) & XIRQ_TRIGGER_HILEVEL) {	\
		x &= ~(0x1 << ((X)+16));	\
	}					\
	else {					\
		x |= 0x1 << ((X)+16);		\
	}					\
	outl(x, DETCONFR2);			\
})

#endif /* _ASM_UNIT_INTCTL_REGS_H */
